define(['angular', 'app'], function (angular, app) {
	"use strict";
	app.service('patient', function ($http, $q, mhpuser) {

		var patient = {},
			isReady;

		patient.fetch = function () {

			if (isReady) {
				return isReady.promise;
			}

			isReady = $q.defer();

			mhpuser.fetch().then(
				function (mhpuser) {
					$http.get(mhpuser['link']['patient']).success(function (response) {
						var patientLinks = new Object();
						response['link'].forEach(function (link) {
							patientLinks[link['title']] = link['href'];
						});
						//fix self uri
						patientLinks['self'] = patientLinks['undefined'];
						delete patientLinks['undefined'];
						response['link'] = patientLinks;
						isReady.resolve(response);
					}).error(function (error) {
						isReady.reject(error);
						isReady = null;
					});
				},
				function (error) {
					isReady.reject(error);
					isReady = null;
				}
			);

			return isReady.promise;
		};

		return patient;
	});
});



